from cryptography.fernet import Fernet; import os, base64, shutil, zipfile

cwd = os.getcwd()

if not os.path.exists("$clean"): os.makedirs("$clean") # not encryprted
if not os.path.exists("$dirty"): os.makedirs("$dirty") # encrypted (dirts/roughs the binary)
    
print("Enter data into approapiate folder:")
print(f"{cwd}\\$clean ||| UNENCRYPTED DATA IN HERE\n{cwd}\\$dirty ||| ENCRYPTED DATA IN HERE")
print("OR leave '$dirty.zip' in:", cwd)
input("Enter to finish: ")
inp = ""
while inp not in ["en", "de"]:
    inp = input("Encrypt (make data dirty) or decrypt (make data clean) (en/de): ")
if inp == "en":
    dust = False
else:
    dust = True
    
key = input("Key?: ").encode("utf-8")

if len(key) < 32:
    key = key + b'\0' * (32 - len(key) - 1) + b"="
elif len(key) > 32:
    key = key[:32] + b"="
    
key = base64.urlsafe_b64encode(key)

u = input("Start?: ")
print()

def ec(name):
    global key
    local_key = str(key)[2:12]
    encrypted_name = []
    name = list(name)
    for i in range(len(name)):
        if name[i].isalpha(): # if character is a-z / A-Z
            if name[i] == name[i].upper(): # if character is uppercase
                letter = "A"
            else: # if character is lower case
                letter = "a"
            encrypted_name.append(chr((((ord(name[i]) + ord(local_key[i % len(local_key)])) - (2 * ord(letter))) % 26) + ord(letter)))
        else:
            encrypted_name.append(name[i])
    return "".join(encrypted_name)

def dc(name):
    global key
    local_key = str(key)[2:12]
    decrypted_name = []
    name = list(name)
    for i in range(len(name)):
        if name[i].isalpha(): # if character is a-z / A-Z
            if name[i] == name[i].upper(): # if character is uppercase
                letter = "A"
            else: # if character is lower case
                letter = "a"
            decrypted_name.append(chr(((ord(name[i]) - ord(local_key[i % len(local_key)])) % 26) + ord(letter)))
        else:
            decrypted_name.append(name[i])
    return "".join(decrypted_name)

def encrypt():
    global end
    for path, dirs, files in os.walk("$clean"):
        if len(dirs) + len(files) == 0:
            end = True
        else:
            end = False
            break
    if end == False:
        inp = ""
        for path, dirs, files in os.walk("$clean", topdown=False): # rename files / directories
            for dir in dirs:
                print(f"Renaming: '{dir}' to '{ec(dir)}'")
                os.rename(os.path.join(path, dir), os.path.join(path, ec(dir)))
            for file in files:
                print(f"Renaming: '{file}' to '{ec(file)}'")
                os.rename(os.path.join(path, file), os.path.join(path, ec(file)))
        for path, dirs, files in os.walk("$clean"): # encrypt + move files / directories
            for dir in dirs:
                print("Transfering:", dir)
                clean_path = os.path.join(path, dir)
                clean_path = clean_path.split("\\")
                dirty_path = os.path.join("$dirty", "\\".join(clean_path[1:]))
                os.makedirs(dirty_path)
            for file in files:
                print("Encrypting:", dc(file), round(os.path.getsize(os.path.join(path, file))/1024, 2), "KB")
                with open(os.path.join(path, file), "rb") as f:
                    data = f.read()
                clean_path = os.path.join(path, file)
                clean_path = clean_path.split("\\")
                dirty_path = os.path.join("$dirty", "\\".join(clean_path[1:]))
                with open(dirty_path, "wb") as f:
                    f.write(Fernet(key).encrypt(data))
    
def decrypt():
    global end
    if end != True:
        inp = ""
        for path, dirs, files in os.walk("$clean", topdown=False): # rename files / directories
            for dir in dirs:
                print(f"Renaming: '{dir}' to '{dc(dir)}'")
                os.rename(os.path.join(path, dir), os.path.join(path, dc(dir)))
            for file in files:
                print(f"Renaming: '{file}' to '{dc(file)}'")
                os.rename(os.path.join(path, file), os.path.join(path, dc(file)))
        try:
            for path, dirs, files in os.walk("$clean"): # decrypt + move files / directories
                for dir in dirs:
                    print("Transfering:", dir)
                    clean_path = os.path.join(path, dir)
                    clean_path = clean_path.split("\\")
                    dirty_path = os.path.join("$dirty", "\\".join(clean_path[1:]))
                    os.makedirs(dirty_path)
                for file in files:
                    print("Decryping:", file)
                    with open(os.path.join(path, file), "rb") as f:
                        data = f.read()
                    clean_path = os.path.join(path, file)
                    clean_path = clean_path.split("\\")
                    dirty_path = os.path.join("$clean", "\\".join(clean_path[1:]))
                    with open(dirty_path, "wb") as f:
                        f.write(Fernet(key).decrypt(data))
        except Exception as e:
            print("Invalid key, ending process...")
            shutil.rmtree("$clean")
            end = True

def zip():
    global end
    if end != True:
        global total_size
        total_size = 0
        with zipfile.ZipFile("$dirty.zip", "w", zipfile.ZIP_DEFLATED) as f:
            for path, dirs, files in os.walk("$dirty", topdown=False):
                for file in files:
                    total_size += os.path.getsize(os.path.join(path, file))
                    print("Zipping:", dc(file), round(os.path.getsize(os.path.join(path, file))/1024, 2), "KB")
                    f.write(os.path.join(path, file))
        compressed_size = os.path.getsize("$dirty.zip")
        print(f"\nCompressed from {round(total_size/(1024**2), 2)} MB to {round(compressed_size/(1024**2), 2)} MB\n{round((compressed_size / total_size) * 100, 2)}%")
    else:
        print("No files in '$clean', ending process...")
        
def unzip():
    global end
    if os.path.isfile("$dirty.zip"):
        print("Unzipping:", os.path.join(cwd, "$dirty.zip"), round(os.path.getsize("$dirty.zip")/(1024**2), 2), "MB")
        with zipfile.ZipFile("$dirty.zip", "r") as f:
            f.extractall()
            name = "$clean" # check in $clean
        if os.path.exists("$clean"):
            shutil.rmtree("$clean")
        os.rename("$dirty", "$clean")
    else:
        name = "$dirty" # check in $dirty
        print("Cannot find '$dirty.zip', checking:", os.path.join(cwd, "$dirty"))
    for path, dirs, files in os.walk(name):
        if len(dirs) + len(files) == 0:
            print("No files in '$dirty', ending process...")
            end = True
        else:
            end = False
            break
    
def delete_excess(dust):
    global end
    print("Deleting leftover files")
    if dust == False:
        if os.path.exists("$clean"):
            shutil.rmtree("$clean")
        if os.path.exists("$dirty"):
            shutil.rmtree("$dirty")
    elif dust == True or end == True:
        if os.path.isfile("$dirty.zip"):
            os.remove("$dirty.zip")
        if os.path.exists("$dirty"):
            shutil.rmtree("$dirty")
        if end == True:
            if os.path.isfile("$dirty.zip"):
                os.remove("$dirty.zip")
                
if dust == False:    
    encrypt()
    zip()
else:
    unzip()
    decrypt()
delete_excess(dust)
print("Finished")